﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.AdvancedLevel
{
    public partial class UCTabAdvancedLevelDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        private BL.BO.AdvancedLevel _previousAdvancedLevel = null;
        private BL.BO.AdvancedLevel _nextAdvancedLevel = null;

        private int _min = 0;
        private int _max = 100;

        private int _minChange = 0;
        private int _maxChange = 100;

        public UCTabAdvancedLevelDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCAdvancedLevelDetails UCDetails
        {
            get { return (UCAdvancedLevelDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            UCDetails.DataManager.Bindings.Add(_gTextBoxName, "Name", _gLabePointsWeight);
            UCDetails.DataManager.Bindings.Add(_gSpinEditSalaryWeight, "SalaryWeight", _gLabelSalaryWeight);
            UCDetails.DataManager.Bindings.Add(_gSpinEditPointsWeight, "PointsWeight", _gLabePointsWeight);

            _gRangeTrackBarFromTo.ValueChanged += new EventHandler(RangeTrackBarFromTo_ValueChanged);
            _gRangeTrackBarChangeFromTo.ValueChanged += new EventHandler(RangeTrackBarChangeFromTo_ValueChanged);
        }

        void RangeTrackBarFromTo_ValueChanged(object sender, EventArgs e)
        {
            if ((_nextAdvancedLevel == null) && (_gRangeTrackBarFromTo.Value.Maximum < 100))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_gRangeTrackBarFromTo.Value.Minimum, 100);
            }

            if ((_nextAdvancedLevel != null) && (_gRangeTrackBarFromTo.Value.Maximum > _max))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_gRangeTrackBarFromTo.Value.Minimum, _max);
            }

            if ((_previousAdvancedLevel == null) && (_gRangeTrackBarFromTo.Value.Minimum > 0))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(0, _gRangeTrackBarFromTo.Value.Maximum);
            }

            if ((_previousAdvancedLevel != null) && (_gRangeTrackBarFromTo.Value.Minimum < _min))
            {
                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_min, _gRangeTrackBarFromTo.Value.Maximum);
            }
        }

        void RangeTrackBarChangeFromTo_ValueChanged(object sender, EventArgs e)
        {
            if ((_nextAdvancedLevel == null) && (_gRangeTrackBarChangeFromTo.Value.Maximum < 100))
            {
                _gRangeTrackBarChangeFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_gRangeTrackBarChangeFromTo.Value.Minimum, 100);
            }

            if ((_nextAdvancedLevel != null) && (_gRangeTrackBarChangeFromTo.Value.Maximum > _maxChange))
            {
                _gRangeTrackBarChangeFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_gRangeTrackBarChangeFromTo.Value.Minimum, _maxChange);
            }

            if ((_previousAdvancedLevel == null) && (_gRangeTrackBarChangeFromTo.Value.Minimum > 0))
            {
                _gRangeTrackBarChangeFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(0, _gRangeTrackBarChangeFromTo.Value.Maximum);
            }

            if ((_previousAdvancedLevel != null) && (_gRangeTrackBarChangeFromTo.Value.Minimum < _minChange))
            {
                _gRangeTrackBarChangeFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(_minChange, _gRangeTrackBarChangeFromTo.Value.Maximum);
            }
        }

        public override void DoRestore()
        {
            if (UCDetails.DataManager.Current != null)
            {
                _gTextBoxDificulty.Text = UCDetails.BLZSBELearning.BLELearning.Categorizatoin.RestoreByEnum((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.Difficulty, UCDetails.DataManager.Current.DifficultyEnumID).Value;

                _previousAdvancedLevel = UCDetails.BLZSBELearning.AdvancedLevel.RestoreByWeight(UCDetails.DataManager.Current.Weight.Value - 1);
                _nextAdvancedLevel = UCDetails.BLZSBELearning.AdvancedLevel.RestoreByWeight(UCDetails.DataManager.Current.Weight.Value + 1);

                if (_previousAdvancedLevel == null)
                {
                    UCDetails.DataManager.Current.From = 0;
                    UCDetails.DataManager.Current.ChangeFrom = 0;
                }
                else
                {
                    _min = _previousAdvancedLevel.From.Value +2;
                    _minChange = _previousAdvancedLevel.ChangeFrom.Value + 2;

                    if (UCDetails.DataManager.Current.From < _min)
                    {
                        UCDetails.DataManager.Current.From = _min;
                    }

                    if (UCDetails.DataManager.Current.ChangeFrom < _minChange)
                    {
                        UCDetails.DataManager.Current.ChangeFrom = _minChange;
                    }
                }

                if (_nextAdvancedLevel == null)
                {
                    UCDetails.DataManager.Current.To = 100;
                    UCDetails.DataManager.Current.ChangeTo = 100;
                }
                else
                {
                    _max = _nextAdvancedLevel.To.Value - 2;
                    _maxChange = _nextAdvancedLevel.ChangeTo.Value - 2;

                    if (UCDetails.DataManager.Current.To > _max)
                    {
                        UCDetails.DataManager.Current.To = _max;
                    }

                    if (UCDetails.DataManager.Current.ChangeTo > _maxChange)
                    {
                        UCDetails.DataManager.Current.ChangeTo = _maxChange;
                    }
                }

                _gRangeTrackBarFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(UCDetails.DataManager.Current.From ?? 0, UCDetails.DataManager.Current.To ?? 0);
                _gRangeTrackBarChangeFromTo.Value = new DevExpress.XtraEditors.Repository.TrackBarRange(UCDetails.DataManager.Current.ChangeFrom ?? 0, UCDetails.DataManager.Current.ChangeTo ?? 0);
            }
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                UCDetails.DataManager.Current.From = _gRangeTrackBarFromTo.Value.Minimum;
                UCDetails.DataManager.Current.To = _gRangeTrackBarFromTo.Value.Maximum;

                UCDetails.DataManager.Current.ChangeFrom = _gRangeTrackBarChangeFromTo.Value.Minimum;
                UCDetails.DataManager.Current.ChangeTo = _gRangeTrackBarChangeFromTo.Value.Maximum;

                if (_previousAdvancedLevel != null)
                {
                    _previousAdvancedLevel.To = UCDetails.DataManager.Current.From.Value - 1;
                    _previousAdvancedLevel.ChangeTo = UCDetails.DataManager.Current.ChangeFrom.Value - 1;
                    UCDetails.BLZSBELearning.AdvancedLevel.Save(_previousAdvancedLevel);
                }

                if (_nextAdvancedLevel != null)
                {
                    _nextAdvancedLevel.From = UCDetails.DataManager.Current.To +1;
                    _nextAdvancedLevel.ChangeFrom = UCDetails.DataManager.Current.ChangeTo + 1;
                    UCDetails.BLZSBELearning.AdvancedLevel.Save(_nextAdvancedLevel);
                }

            }
            return true;
        }
    }
}
